//
//  RNNoiseExtension.hpp
//  SwitchboardRNNoise
//
//  Created by Iván Nádor on 2023. 01. 09..
//

#pragma once

#include "RNNoiseNodeFactory.hpp"

#include <switchboard_core/Extension.hpp>
#include <switchboard_core/Switchboard.hpp>

#if not defined(SWITCHBOARD_WEB)
extern "C" {
void sb_extension_init(std::map<std::string, std::any> config);
}
#endif

namespace switchboard::extensions::rnnoise {

class RNNoiseExtension final : public Extension {
public:
    SB_WASM_EXPORT(RNNoiseExtension)

    SB_WASM static void initialize();

    // MARK: Overridden methods

    std::string getName();
    std::shared_ptr<NodeFactory> getNodeFactory();

private:
    static RNNoiseExtension* sharedInstance;
    std::shared_ptr<RNNoiseNodeFactory> nodeFactory;

    RNNoiseExtension();
};

}
