//
//  SBTimelineNode.h
//  SwitchboardSDK
//
//  Created by Mihály Gergye on 2025. 03. 10..
//

#import <Foundation/Foundation.h>
#import "SBAudioSourceNode.h"

NS_ASSUME_NONNULL_BEGIN

@interface SBTimelineNode : SBAudioSourceNode

@property (nonatomic, assign) float position;

- (void)start;
- (void)pause;
- (void)stop;
- (void)setBpm:(int)bpm;
- (void)setLoopEnabled:(BOOL)enabled;
- (void)setLoop:(float)start end:(float)end;
- (void)setQuantizedLoop:(float)quantization length:(float)length;
- (void)setReverse:(BOOL)reverse;

@end

NS_ASSUME_NONNULL_END
