//
//  SBSynchronizedAudioPlayerNode.h
//  SwitchboardSDK
//
//  Created by Mihály Gergye on 2025. 03. 10..
//

#import <Foundation/Foundation.h>
#import "SBAudioProcessorNode.h"
#import "SBCodec.h"

NS_ASSUME_NONNULL_BEGIN

@interface SBSynchronizedAudioPlayerNode : SBAudioProcessorNode

@property (nonatomic, assign) float position;

- (void)setOffset:(double)offset;
- (void)setStartOffset:(double)offset;
- (void)setEndOffset:(double)offset;
- (void)setRepeat:(BOOL)repeat;
- (void)load:(NSString*)path;
- (void)load:(NSString*)path withFormat:(SBCodec)format;
- (double)durationMs;

@end

NS_ASSUME_NONNULL_END
