//
//  AudioGraphNodeConnection.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 27..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioBusFormat.hpp"
#include "Switchboard.hpp"

#include <optional>

namespace switchboard {

/**
 * AudioGraphNodeConnection class.
 * @brief Represents a connection between two audio nodes in the AudioGraph class.
 */
struct AudioGraphNodeConnection {
public:
    /// @brief ID of source node.
    uint sourceNode;

    /// @brief ID of destination node.
    uint destNode;

    /// @brief The bus index of the source node.
    std::optional<uint> sourceBusIndex;

    /// @brief The bus index of the destination node.
    std::optional<uint> destBusIndex;

    /// @brief The audio bus format of the source node.
    AudioBusFormat* sourceBusFormat;

    /// @brief The audio bus format of the destination node.
    AudioBusFormat* destBusFormat;
};

}
