//
//  AudioNodeFactory.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 07. 05..
//

#pragma once

#include "AudioNode.hpp"

#include <any>
#include <map>
#include <string>

namespace switchboard {

/**
 * AudioNodeFactory class.
 * @brief Creates audio node instances.
 */
class AudioNodeFactory {
public:
    /**
     * @brief Returns the prefix of the audio node type.
     * @details The prefix is used to identify the audio node type and it follows the format: <extension name>.<audio node type>.
     *
     * @returns The prefix of the audio node type.
     */
    virtual std::string getNodeTypePrefix() = 0;

    /**
     * @brief Creates an AudioNode instance based on type information.
     * @details The returned audio node instances need to be freed by the user of the AudioNodeFactory.
     *
     * @param type The type of the audio node.
     * @param config Configuration values for the audio node.
     *
     * @returns A pointer to the created AudioNode instance, or nullptr if the audio node could not be created.
     */
    virtual AudioNode* createNode(const std::string& type, const std::map<std::string, std::any>& config) = 0;
};

}
