//
//  BusSplitterNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 23..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioProcessorNode.hpp"

namespace switchboard {

/**
 * BusSplitterNode class
 * @brief Splits a single audio bus into multiple audio buses.
 */
class BusSplitterNode : public AudioProcessorNode {
public:
    WASM_EXPORT(BusSplitterNode)

    /**
     * @brief Creates a BusSplitterNode instance.
     */
    WASM BusSplitterNode();

    // MARK: Overridden methods

    WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    WASM bool process(AudioBusList& inAudioBuses, AudioBusList& outAudioBuses) override;
};

}
