//
//  BusSwitchNode.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2024. 08. 08..
//

#pragma once

#include "AudioProcessorNode.hpp"
#include "Switchboard.hpp"

namespace switchboard {

/**
 *  BusSwitchNode class.
 *  @brief Forwards a single input audio bus to a single output audio bus out of multiple output audio buses
 */
class BusSwitchNode : public AudioProcessorNode {
public:
    WASM_EXPORT(BusSwitchNode)

    /**
     *  @brief Initializes a BusSwitchNode instance.
     */
    WASM BusSwitchNode();

    /**
     * @brief Gets the current selected bus index.
     *
     * @returns The bus index.
     */
    WASM uint getSelectedBus() const;

    /**
     * @brief Sets the selected bus index.
     * @details Will return false if the bus index is bigger than or equal than max number of output buses.
     *
     * @param newValue The bus index to set.
     * @returns True if setting the selected bus index was successful.
     */
    WASM bool setSelectedBus(const uint newValue);

    /**
     * @brief Gets the number of output buses of the node.
     *
     * @returns The number of output buses.
     */
    WASM uint getNumberOfOutputBuses() const;

    // MARK: Overridden methods

    WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    WASM bool process(AudioBusList& inBuses, AudioBusList& outBuses) override;

private:
    uint numberOfOutputBuses;
    std::atomic<uint> selectedBus;
};

}
