//
//  ChannelSplitterNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include "AudioProcessorNode.hpp"

namespace switchboard {

/**
 * @brief Splits a multi channel audio bus to multiple mono audio buses.
 */
class ChannelSplitterNode : public AudioProcessorNode {
public:
    WASM_EXPORT(ChannelSplitterNode)

    /**
     * @brief Initializes a ChannelSplitterNode instance.
     */
    WASM ChannelSplitterNode();

    // MARK: Overridden methods

    WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    WASM bool process(AudioBusList& inAudioBuses, AudioBusList& outAudioBuses) override;
};

}
