//
//  ConsoleLogDestination.hpp
//  SwitchboardSDK
//
//  Created by Pesti József on 2022. 12. 20..
//

#pragma once

#include "LogDestination.hpp"

#include <mutex>

namespace switchboard {
/**
 * ConsoleLogDestination class.
 * @brief Provides a logging option for the standard output. Singleton.
 */
class ConsoleLogDestination : public LogDestination {
public:
    /**
     * @brief Gets the ConsoleLogDestination instance.
     *
     * @returns The instance.
     */
    static ConsoleLogDestination& getInstance();

private:
    static ConsoleLogDestination* sharedInstance;

    std::mutex consoleLogMutex;

    ConsoleLogDestination() {}
    ConsoleLogDestination(const ConsoleLogDestination&);
    ConsoleLogDestination& operator=(const ConsoleLogDestination&);

    void log(const LogLevel logLevel, const std::string& logMessage);
};

}
