//
//  Deinterleave.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 04. 04..
//

#pragma once

#include "AudioBuffer.hpp"
#include "Switchboard.hpp"

namespace switchboard {

/**
 *  @brief Deinterleaves audio data from input buffer into output buffers.
 *
 *  @param inputBuffer The interleaved input audio array.
 *  @param outputBuffers Output audio data arrays where the deinterleaved data will be stored.
 *  @param numberOfChannels The number of channels to deinterleave.
 *  @param numberOfFrames The number of frames in the input buffers.
 */
template <typename T>
void deinterleave(const T* inputBuffer, T** outputBuffers, const uint numberOfChannels, const uint numberOfFrames);

/**
 *  @brief Deinterleaves input buffer into output buffer channels
 *  @details Input and output buffers must have the same number of channels. Input and output buffers must have the same number of frames.
 *
 *  @param inputBuffer AudioBuffer to be deinterleaved. Must be interleaved.
 *  @param outputBuffer AudioBuffer to store input data. Must be non-interleaved.
 */
template <typename T>
void deinterleave(const AudioBuffer<T>& inputBuffer, AudioBuffer<T>& outputBuffer);

}
