//
//  DuckingCompressor.h
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 03..
//

#pragma once

#include "Switchboard.hpp"

namespace switchboard {

/**
 * @brief Abstract base class for compressors that can be used for audio ducking.
 */
class DuckingCompressor {
public:
    /**
     * @brief DuckingCompressor destructor.
     */
    virtual ~DuckingCompressor() {};

    /**
     * @brief Sets the sample rate.
     *
     * @param sampleRate The new sampleRate.
     */
    virtual void setSampleRate(const uint sampleRate) = 0;

    /**
     * @brief Sets he threshold of the compressor in dB (0 = no ducking).
     *
     * @param threshold The new threshold value in dB.
     */
    virtual void setThresholdDb(const float threshold) = 0;

    /**
     * @brief Runs the audio compression algorithm on an audio buffer.
     *
     * @param buffer The stereo interleaved audio buffer.
     * @param numberOfFrames The number of frames in the audio buffer.
     */
    virtual void process(float* buffer, const uint numberOfFrames) = 0;
};

}
