//
//  Extension.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 30/08/2024.
//

#pragma once

#include "AudioNodeFactory.hpp"

#include <string>

namespace switchboard {

/**
 * @brief Interface for Switchboard SDK extensions.
 */
class Extension {
public:
    /**
     * @brief Destructor.
     */
    virtual ~Extension() = default;

    /**
     * @brief Gets the name of the extension.
     * 
     * @return std::string The name of the extension.
     */
    virtual std::string getName() = 0;

    /**
     * @brief Gets the AudioNodeFactory object of the extension.
     * @details The AudioNodeFactory object is used to create custom audio nodes.
     * 
     * @return std::shared_ptr<AudioNodeFactory> The AudioNodeFactory object of the extension.
     */
    virtual std::shared_ptr<AudioNodeFactory> getAudioNodeFactory() = 0;
};

}
