//
//  ExtensionManager.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 30/08/2024.
//

#pragma once

#include "Extension.hpp"

namespace switchboard {

/**
 * @brief Manages the extensions of the Switchboard SDK.
 */
class ExtensionManager {
public:
    /**
     * @brief Gets the shared instance of the ExtensionManager.
     */
    static ExtensionManager& getInstance();

    /**
     * @brief Registers an extension.
     * 
     * @param extension The extension to register.
     */
    void registerExtension(Extension& extension);

private:
    static ExtensionManager* sharedInstance;

    std::vector<Extension*> extensions;
};

}
