//
//  FloatStoredParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "FloatParameter.hpp"

namespace switchboard {

/**
 * @brief FloatStoredParameter class. A float parameter class that contains an float variable.
 */
class FloatStoredParameter : public FloatParameter {
public:
    WASM_EXPORT(FloatStoredParameter)

    /**
     * @brief FloatStoredParameter constructor with a default value.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param defaultValue Default float value.
     * @param minimumValue Minimum value for the parameter.
     * @param maximumValue Maximum value for the parameter.
     */
    WASM FloatStoredParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        const float defaultValue,
        const float minimumValue,
        const float maximumValue
    );

    // MARK: Overridden methods

    WASM float getValue() const override;
    WASM void setValue(const float newValue) override;
    WASM float getMinimumValue() const override;
    WASM float getMaximumValue() const override;

private:
    std::atomic<float> atomicValue;
    float minimumValue;
    float maximumValue;
};

}
