//
//  IntToFloat.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 04. 04..
//

#pragma once

#include "Switchboard.hpp"

#include <climits>

namespace switchboard {

/**
 * @brief Converts an int (32 bit) audio value to float (32 bit).
 * @details The conversion happens in the sense of audio values, meaning float has a range of -1.0...1.0 and int has -2147483647...2147483647.
 *
 * @param value The input value in int.
 *
 * @returns The value in float.
 */
inline float intToFloat(int value) {
    return static_cast<float>(value) / INT_MAX;
}

/**
 *  @brief Convert a signed 32-bit integer buffer to a float buffer.
 *
 *  @param inputBuffer Input signed 32-bit integer buffer.
 *  @param outputBuffer Output float buffer.
 *  @param numberOfSamples Number of samples in the buffers.
 */
void intToFloat(const int* inputBuffer, float* outputBuffer, size_t numberOfSamples);

}
