//
//  Limit.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 01. 05..
//

#pragma once

#include "Switchboard.hpp"

namespace switchboard {

/**
 * @brief Limits a value between lowerLimit and upperLimit.
 * @details lowerLimit <= upperLimit is expected.
 *
 * @param lowerLimit The minimum value.
 * @param upperLimit The maximum value.
 * @param value The value to be limited.
 *
 * @returns The original value if it is between the limits, the appropriate limit otherwise.
 */
template <typename T>
T limit(T lowerLimit, T upperLimit, T value) noexcept;

}
