//
//  Logger.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2017. 10. 05..
//  Copyright © 2017. Synervoz Inc. All rights reserved.
//

#pragma once

#include "LogDestination.hpp"
#include "LogLevel.hpp"

#include <string>

namespace switchboard {

/**
 * Logger class.
 * @brief Provides logging functionality.
 */
class Logger {
public:
    /**
     * @brief Sets the log destination of the logger.
     */
    static void setLogDestination(LogDestination* destination);

    /**
     * @brief Gets the log destination of the logger.
     *
     * @returns The current log destination.
     */
    static LogDestination* getLogDestination();

    /**
     * @brief Sets the log level of the logger.
     *
     * @param level The log level to be set.
     */
    static void setLogLevel(LogLevel level);

    /**
     * @brief Gets the log level of the logger.
     *
     * @returns The current log level.
     */
    static LogLevel getLogLevel();

    /**
     * @brief Logs a trace level message.
     *
     * @param logMessage The log message.
     */
    static void trace(const std::string& logMessage);

    /**
     * @brief Logs a debug level message.
     *
     * @param logMessage The log message.
     */
    static void debug(const std::string& logMessage);

    /**
     * @brief Logs an info level message.
     *
     * @param logMessage The log message.
     */
    static void info(const std::string& logMessage);

    /**
     * @brief Logs a warning level message.
     *
     * @param logMessage The log message.
     */
    static void warning(const std::string& logMessage);

    /**
     * @brief Logs an error level message.
     *
     * @param logMessage The log message.
     */
    static void error(const std::string& logMessage);

private:
    static LogLevel logLevel;
    static LogDestination* destination;
};

}
