//
//  MonoToMultiChannelNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include "SingleBusAudioProcessorNode.hpp"

namespace switchboard {

/**
 * @brief Converts a mono audio bus to a multi-channel audio bus.
 */
class MonoToMultiChannelNode : public SingleBusAudioProcessorNode {
public:
    WASM_EXPORT(MonoToMultiChannelNode)

    /**
     * @brief Initializes a MonoToMultiChannelNode instance.
     */
    WASM MonoToMultiChannelNode();

    // MARK: Overridden methods

    WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat);
    WASM bool process(AudioBus& inBus, AudioBus& outBus);
};

}
