//
//  MultiChannelToMonoNode.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2022. 12. 29..
//

#pragma once

#include "SingleBusAudioProcessorNode.hpp"

#include <atomic>

namespace switchboard {

/**
 * @brief Converts a multi-channel audio bus to a mono audio bus.
 */
class MultiChannelToMonoNode : public SingleBusAudioProcessorNode {
public:
    WASM_EXPORT(MultiChannelToMonoNode)

    /**
     * @brief Initializes a MultiChannelToMono instance.
     */
    WASM MultiChannelToMonoNode();

    /**
     * @brief Enables signal normalization to the largest signal after mixing.
     *
     * @param normalize True if the signals have to be normalized to the largest signal after mixing.
     */
    WASM void setNormalize(const bool normalize);

    /**
     * @brief Gets if signal normalization to the largest signal after mixing is enabled.
     *
     * @returns True if the signals have to be normalized to the largest signal after mixing.
     */
    WASM bool getNormalize() const;

    // MARK: Overridden methods

    WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat);
    WASM bool process(AudioBus& inBus, AudioBus& outBus);

private:
    std::atomic<bool> normalize;
};

}
