//
//  MuteNode.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 03. 23..
//

#pragma once

#include "SingleBusAudioProcessorNode.hpp"

namespace switchboard {

/**
 * MuteNode class.
 * @brief Node that mutes and unmutes an audio stream.
 */
class MuteNode : public SingleBusAudioProcessorNode {
public:
    WASM_EXPORT(MuteNode)

    /**
     * @brief MuteNode constructor.
     */
    WASM MuteNode();

    /**
     * @brief Returns whether the node is muting or not.
     *
     * @returns True if the node is muting the audio stream, false otherwise.
     */
    WASM bool getIsMuted() const;

    /**
     * @brief Enables or disables muting.
     *
     * @param newValue The new muting setting.
     */
    WASM void setIsMuted(const bool newValue);

    // MARK: Overridden methods

    WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat) override;
    WASM bool process(AudioBus& inBus, AudioBus& outBus) override;

private:
    bool isMuted;
};

}
