//
//  ResampledSinkNode.hpp
//  SwitchboardSDK
//
//  Created by Gergye Mihály on 2023. 07. 04..
//

#pragma once

#include "Resampler.hpp"
#include "SingleBusAudioSinkNode.hpp"

namespace switchboard {

/**
 * ResampledSinkNode class.
 * @brief Encapsulates a SingleBusAudioSinkNode and provides environment for it with specified sample rate.
 */
class ResampledSinkNode : public SingleBusAudioSinkNode {
public:
    /**
     * @brief ResampledSinkNode constructor.
     */
    ResampledSinkNode();

    /**
     * @brief Sets the internal sink node for the ResampledSinkNode (the sample rate of the encapsulated sink node).
     *
     * @param sinkNode The encapsulated sink node.
     */
    void setSinkNode(SingleBusAudioSinkNode* sinkNode);

    /**
     * @brief Returns the internally set sample rate for the sink node.
     *
     * @returns The internal sample rate.
     */
    uint getInternalSampleRate() const;

    /**
     * @brief Sets the internal sample rate for the encapsulated sink node (the sample rate of the encapsulated sink node).
     *
     * @param internalSampleRate The desired internal sample rate.
     */
    void setInternalSampleRate(const uint internalSampleRate);

    // MARK: Overriden methods
    bool setBusFormat(AudioBusFormat& busFormat) override;
    bool consume(AudioBus& bus) override;

private:
    uint internalSampleRate;
    AudioBusFormat internalFormat;
    SingleBusAudioSinkNode* sinkNode;
    Resampler resampler;

    RingBuffer<float> ringBuffer;
    AudioData<float> temporaryData;
    AudioData<float> temporaryInterleavedStereoBuffer;
};
} // namespace
