//
// Created by Balazs Kiss on 2023. 01. 16..
//

#pragma once

#include <jni.h>
#include <memory>

/**
 * Mapping between Java and C++ objects.
 */
template <class T>
class SBJNIObjectMapping {

public:
    /**
     * Initializes an instance with a Java object and a C++ object pointer.
     *
     * @param jObject The Java object (Global reference)
     * @param cppObject The Cpp object pointer
     */
    SBJNIObjectMapping(jobject jObject, T* cppObject) : javaObject(jObject), cppObject(cppObject) {}

    /**
     *
     * Initializes an instance with a Java object and a C++ shared pointer.
     *
     * @param jObject The Java object (Global reference)
     * @param sharedCppObject The shared pointer to the Cpp object
     */
    SBJNIObjectMapping(jobject jObject, std::shared_ptr<T> sharedCppObject) :
        javaObject(jObject),
        cppObject(nullptr),
        sharedCppObject(sharedCppObject) {}

    /**
     * Returns the Java object.
     *
     * @return The Java object.
     */
    jobject getJavaObject() {
        return javaObject;
    }

    /**
     * Returns the C++ object.
     *
     * @return The C++ object.
     */
    T* getCppObject() {
        if (sharedCppObject == nullptr) {
            return cppObject;
        } else {
            return sharedCppObject.get();
        }
    }

private:
    jobject javaObject;
    T* cppObject;
    std::shared_ptr<T> sharedCppObject;
};