//
//  SimpleDuckingCompressor.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 03..
//

#pragma once

#include "DuckingCompressor.hpp"

namespace switchboard {

/**
 * @brief A simple ducking compressor implementation that adjusts the gain of the processed audio buffers.
 */
class SimpleDuckingCompressor : public DuckingCompressor {
public:
    /**
     * @brief SimpleDuckingCompressor constructor.
     */
    SimpleDuckingCompressor();

    /**
     * @brief SimpleDuckingCompressor destructor.
     */
    ~SimpleDuckingCompressor();

    // MARK: Overridden methods
    void setSampleRate(const uint sampleRate);
    void setThresholdDb(const float threshold);
    void process(float* buffer, const uint numberOfFrames);

private:
    float thresholdDb;
    float gain;
};

}
