//
//  SineGeneratorNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 20..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "SineGenerator.hpp"
#include "SingleBusAudioSourceNode.hpp"

#include <any>
#include <map>

namespace switchboard {

/**
 * SineGeneratorNode class.
 * @brief Generates a sine wave with the given frequency and amplitude.
 */
class SineGeneratorNode : public SingleBusAudioSourceNode {
public:
    WASM_EXPORT(SineGeneratorNode)

    WASM SineGeneratorNode();

    /**
     * @brief Creates a SineGeneratorNode instance.
     *
     * @param config Configuration map for the node.
     */
    SineGeneratorNode(const std::map<std::string, std::any>& config);

    /**
     * @brief Gets the current frequency value of the generated sine wave.
     *
     * @returns The frequency value in Hz.
     */
    WASM float getFrequency() const;

    /**
     * @brief Sets the frequency of the generated sine wave.
     *
     * @param frequency The new frequency value in Hz.
     */
    WASM void setFrequency(const float frequency);

    /**
     * @brief Gets the current amplitude value of the generated sine wave.
     *
     * @returns The amplitude value.
     */
    WASM float getAmplitude() const;

    /**
     * @brief Sets the amplitude of the generated sine wave.
     *
     * @param amplitude The new amplitude value. Should be between 0 and 1.
     */
    WASM void setAmplitude(const float amplitude);

    // MARK: Overridden methods

    WASM bool setBusFormat(AudioBusFormat& busFormat) override;
    WASM bool produce(AudioBus& bus) override;

private:
    SineGenerator sineGenerator;

    void createParameters();
};

}
