//
//  SingleBusAudioSinkNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioSinkNode.hpp"

namespace switchboard {

/**
 * SingleBusAudioSinkNode class.
 * @brief Provides a simplified interface for AudioSinkNode which is useful when only a single bus is supported by the audio sink.
 */
class SingleBusAudioSinkNode : public AudioSinkNode {
public:
    /**
     * @brief Sets bus format.
     * @details Should be overridden by subclasses.
     *
     * @param busFormat The bus format to set.
     *
     * @returns True if the bus format was set successfully, false otherwise.
     */
    virtual bool setBusFormat(AudioBusFormat& busFormat) = 0;

    /**
     * @brief Consumes audio data from the given bus.
     * @details Should be overridden by subclasses.
     *
     * @param bus The bus that contain the audio data.
     *
     * @returns True if audio was consumed successfully, false otherwise.
     */
    virtual bool consume(AudioBus& bus) = 0;

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfBuses) override;
    bool setBusFormats(AudioBusFormatList& busFormats) override;
    bool consume(AudioBusList& buses) override;
};

}
