//
//  SingleBusAudioSourceNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioSourceNode.hpp"

namespace switchboard {

/**
 * SingleBusAudioSourceNode class.
 * @brief Provides a simplified interface for AudioSourceNode which is useful when only a single bus is supported by the audio source.
 */
class SingleBusAudioSourceNode : public AudioSourceNode {
public:
    /**
     * @brief Sets bus format.
     * @details Should be overridden by subclasses.
     *
     * @param busFormat The bus format to set.
     *
     * @returns True if the bus format was set successfully, false otherwise.
     */
    virtual bool setBusFormat(AudioBusFormat& busFormat) = 0;

    /**
     * @brief Produces audio data in the given bus.
     * @details Should be overridden by subclasses.
     *
     * @param bus The bus that should be filled with audio data.
     *
     * @returns True if audio was produced successfully, false otherwise.
     */
    virtual bool produce(AudioBus& bus) = 0;

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfBuses) override;
    bool setBusFormats(AudioBusFormatList& busFormats) override;
    bool produce(AudioBusList& buses) override;
};

}
