//
//  StringParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "Parameter.hpp"

namespace switchboard {

/**
 * @brief String parameter abstract class. Intended to be subclassed.
 */
class StringParameter : public Parameter {
public:
    /**
     * @brief StringParameter constructor.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     */
    StringParameter(const std::string& id, const std::string& name, const std::string& description);

    /**
     * @brief StringParameter destructor.
     */
    virtual ~StringParameter() = default;

    /**
     * @brief Gets the current value of the parameter.
     *
     * @returns The current value.
     */
    virtual std::string getValue() const = 0;

    /**
     * @brief Sets a new value for the parameter.
     *
     * @param newValue The new value for the parameter.
     */
    virtual void setValue(const std::string newValue) = 0;

    // MARK: Overidden methods

    void setValue(std::any newValue) override;
    std::any getAnyValue() override;
};

}
