//
//  StringStoredParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "StringParameter.hpp"

namespace switchboard {

/**
 * @brief StringStoredParameter class.
 */
class StringStoredParameter : public StringParameter {
public:
    WASM_EXPORT(StringStoredParameter)

    /**
     * @brief StringStoredParameter constructor with a default value.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param defaultValue Default string value.
     */
    WASM StringStoredParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        const std::string defaultValue
    );

    // MARK: Overridden methods

    WASM std::string getValue() const override;
    WASM void setValue(const std::string newValue) override;

private:
    std::string atomicValue;
};

}
