//
//  SwitchboardObject.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2025. 01. 22..
//

#pragma once

#include "EventEmitter.hpp"

#include <any>
#include <map>
#include <string>
#include <switchboard/Result.hpp>

namespace switchboard {

/**
 * @brief SwitchboardObject interface.
 */
class SwitchboardObject : public EventEmitter {
public:
    /**
     * @brief SwitchboardObject destructor.
     */
    virtual ~SwitchboardObject() = default;

    /**
     * @brief Sets a value on the object.
     *
     * @param key The key of the value.
     * @param value The value to set.
     * 
     * @return A successful result if the value was set successfully, an error result otherwise.
     */
    virtual Result<void> setValue(const std::string& key, const std::any& value) = 0;

    /**
     * @brief Gets a value from the object.
     *
     * @param key The key of the value.
     * 
     * @return The value.
     */
    virtual Result<std::any> getValue(const std::string& key) = 0;

    /**
     * @brief Calls an action on the object.
     *
     * @param actionName The name of the action.
     * @param params The parameters of the action.
     * 
     * @return The result of the action.
     */
    virtual Result<std::any>
        callAction(const std::string& actionName, const std::map<std::string, std::any>& params) = 0;
};

}
