//
//  UIntParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "Parameter.hpp"

namespace switchboard {

/**
 * @brief UInt parameter abstract class. Intended to be subclassed.
 */
class UIntParameter : public Parameter {
public:
    /**
     * @brief UIntParameter constructor.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     */
    UIntParameter(const std::string& id, const std::string& name, const std::string& description);

    /**
     * @brief UIntParameter destructor.
     */
    virtual ~UIntParameter() = default;

    /**
     * @brief Gets the current value of the parameter.
     *
     * @returns The current value.
     */
    virtual uint getValue() const = 0;

    /**
     * @brief Sets a new value for the parameter.
     *
     * @param newValue The new value for the parameter.
     */
    virtual void setValue(const uint newValue) = 0;

    /**
     * @brief Gets the minimum value for the parameter.
     *
     * @returns The minimum value.
     */
    virtual uint getMinimumValue() const = 0;

    /**
     * @brief Gets the maximum value for the parameter.
     *
     * @returns The maximum value.
     */
    virtual uint getMaximumValue() const = 0;

    // MARK: Overidden methods

    void setValue(std::any newValue) override;
    std::any getAnyValue() override;
};

}
