//
//  UIntStoredParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "UIntParameter.hpp"

namespace switchboard {

/**
 * @brief UIntStoredParameter class. A uint parameter class that contains an uint variable.
 */
class UIntStoredParameter : public UIntParameter {
public:
    WASM_EXPORT(UIntStoredParameter)

    /**
     * @brief UIntStoredParameter constructor with a default value.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param defaultValue Default uint value.
     * @param minimumValue Minimum value for the parameter.
     * @param maximumValue Maximum value for the parameter.
     */
    WASM UIntStoredParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        const uint defaultValue,
        const uint minimumValue,
        const uint maximumValue
    );

    // MARK: Overridden methods

    WASM uint getValue() const override;
    WASM void setValue(const uint newValue) override;
    WASM uint getMinimumValue() const override;
    WASM uint getMaximumValue() const override;

private:
    std::atomic<uint> atomicValue;
    uint minimumValue;
    uint maximumValue;
};

}
