//
//  AudioSinkNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 03..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioBusFormatList.hpp"
#include "AudioBusList.hpp"
#include "AudioNode.hpp"

namespace switchboard {

/**
 * AudioSinkNode class.
 * @brief A node that consumes audio and only has incoming connections.
 */
class AudioSinkNode : public AudioNode {
public:
    /**
     * @brief Sets number of buses.
     * @details Should be overridden by subclasses.
     *
     * @param numberOfBuses The number of buses to set.
     *
     * @returns True if the number of buses was set successfully, false otherwise.
     */
    virtual bool setNumberOfBuses(const uint numberOfBuses) = 0;

    /**
     * @brief Sets bus formats.
     * @details Should be overridden by subclasses.
     *
     * @param busFormats The bus formats to set.
     *
     * @returns True if the bus formats were set successfully, false otherwise.
     */
    virtual bool setBusFormats(AudioBusFormatList& busFormats) = 0;

    /**
     * @brief Consumes audio data from the given buses.
     * @details Should be overridden by subclasses.
     *
     * @param buses The buses that contain the audio data.
     *
     * @returns True if audio was consumed successfully, false otherwise.
     */
    virtual bool consume(AudioBusList& buses) = 0;
};

}
