//
//  AudioSourceNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 03..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioBusList.hpp"
#include "AudioNode.hpp"

namespace switchboard {

/**
 * AudioSourceNode class.
 * @brief A node that produces audio and only has outgoing connections.
 */
class AudioSourceNode : public AudioNode {
public:
    /**
     * @brief Sets number of buses.
     * @details Should be overridden by subclasses.
     *
     * @param numberOfBuses The number of buses to set.
     *
     * @returns True if the number of buses was set successfully, false otherwise.
     */
    virtual bool setNumberOfBuses(const uint numberOfBuses) = 0;

    /**
     * @brief Sets bus formats.
     * @details Should be overridden by subclasses.
     *
     * @param busFormats The bus formats to set.
     *
     * @returns True if the bus formats were set successfully, false otherwise.
     */
    virtual bool setBusFormats(AudioBusFormatList& busFormats) = 0;

    /**
     * @brief Produces audio data in the given buses.
     * @details Should be overridden by subclasses.
     *
     * @param buses The buses that should be filled with audio data.
     *
     * @returns True if audio was produced successfully, false otherwise.
     */
    virtual bool produce(AudioBusList& buses) = 0;
};

}
