//
//  LogLevel.hpp
//  SwitchboardSDK
//
//  Created by Pesti József on 2022. 12. 19..
//

#pragma once

#include <string>

namespace switchboard {

enum LogLevel { None = 0, Error = 1, Warning = 2, Info = 3, Debug = 4, Trace = 5 };

/**
 * @brief Converts a string to a LogLevel enum value.
 * 
 * @param stringValue The string representation of the log level.
 * 
 * @return The corresponding LogLevel enum value.
 */
LogLevel logLevelFromString(const std::string& stringValue);

/**
 * @brief Converts a LogLevel enum value to a string.
 * 
 * @param logLevel The LogLevel enum value.
 * 
 * @return The string representation of the log level.
 */
std::string logLevelToString(LogLevel logLevel);

}
