//
//  SingleBusAudioProcessorNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 06. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "AudioProcessorNode.hpp"

namespace switchboard {

/**
 * SingleBusAudioProcessorNode class.
 * @brief Provides a simplified interface for AudioProcessorNode which is useful when only a single bus is supported by the audio processor.
 */
class SingleBusAudioProcessorNode : public AudioProcessorNode {
public:
    /**
     * @brief Sets bus format.
     * @details Should be overridden by subclasses.
     *
     * @param inputBusFormat The input bus format to set.
     * @param outputBusFormat The output bus format to set.
     *
     * @returns True if the bus formats were set successfully, false otherwise.
     */
    virtual bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat) = 0;

    /**
     * @brief Processes audio data from the given input bus and produces the audio output to the given output bus.
     * @details Should be overridden by subclasses.
     *
     * @param inBus The input bus that contain the audio data.
     * @param outBus The output bus which should be filled with the processed audio data.
     *
     * @returns True if audio was processed successfully, false otherwise.
     */
    virtual bool process(AudioBus& inBus, AudioBus& outBus) = 0;

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    bool process(AudioBusList& inBuses, AudioBusList& outBuses) override;
};

}
