//
//  AudioBusFormatArray.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 03/03/2024.
//

#pragma once

#include <array>
#include <switchboard_core/AudioBusFormatList.hpp>

namespace switchboard {

/**
 * AudioBusFormatArray class.
 * @brief Holds a list of AudioBusList instances on the stack.
 * @details Represents formats of AudioBusList instances without the need for the audio data.
 * @see AudioBusFormatList
 * @see AudioBusFormatVector
 */
template <std::size_t N>
class AudioBusFormatArray : public AudioBusFormatList {
public:
    /**
     * @brief Creates an AudioBusFormatArray instance.
     * @details Allocates enough memory on the stack to hold the AudioBusFormat instances.
     */
    AudioBusFormatArray() = default;

    // MARK: Overridden methods

    uint getNumberOfBuses() const override;
    AudioBusFormat& getBusFormat(const uint busIndex) const override;
    AudioBusFormatList& operator=(const AudioBusFormatList& other) override;

private:
    std::array<AudioBusFormat, N> busFormats;
};

}
