//
//  AudioGraphInputNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include <switchboard_core/AudioSourceNode.hpp>

namespace switchboard {

/**
 * AudioGraphInputNode class.
 * @brief Represents the input node of the audio graph.
 */
class AudioGraphInputNode : public AudioSourceNode {
public:
    /**
     * @brief Creates an AudioGraphInputNode instance.
     */
    AudioGraphInputNode();

    /**
     * @brief Sets the source of the audio data.
     * @details The AudioGraph instance is responsible for calling this method.
     *
     * @param graphInAudioBuses An AudioBusList instance that has the audio input data.
     */
    void setGraphInAudioBuses(const AudioBusList* graphInAudioBuses);

    /**
     * @brief Gets the number of buses that was set by the AudioGraph.
     *
     * @returns The number of buses.
     */
    uint getNumberOfBuses() const;

    // MARK: Overridden methods

    bool setNumberOfBuses(const uint numberOfBuses) override;
    bool setBusFormats(AudioBusFormatList& busFormats) override;
    bool produce(AudioBusList& buses) override;

private:
    const AudioBusList* graphInAudioBuses;
    uint numberOfBuses;
};

}
