//
//  BoolParameter.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 26..
//

#pragma once

#include <switchboard_core/Parameter.hpp>

namespace switchboard {

/**
 * @brief Boolean parameter abstract class. Intended to be subclassed.
 */
class BoolParameter : public Parameter {
public:
    /**
     * @brief BoolParameter constructor.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     */
    BoolParameter(const std::string& id, const std::string& name, const std::string& description);

    /**
     * @brief BoolParameter destructor.
     */
    virtual ~BoolParameter() = default;

    /**
     * @brief Gets the current value of the parameter.
     *
     * @returns The current value.
     */
    virtual bool getValue() const = 0;

    /**
     * @brief Sets a new value for the parameter.
     *
     * @param newValue The new value for the parameter.
     */
    virtual void setValue(const bool newValue) = 0;

    // MARK: Overidden methods

    void setValue(std::any newValue) override;
    std::any getAnyValue() override;
};

}
