//
//  BoolStoredParameter.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 07. 11..
//

#pragma once

#include "BoolParameter.hpp"

namespace switchboard {

/**
 * @brief BoolStoredParameter class. A bool parameter class that contains an bool variable.
 */
class BoolStoredParameter : public BoolParameter {
public:
    SB_WASM_EXPORT(BoolStoredParameter)

    /**
     * @brief BoolStoredParameter constructor with a default value.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     * @param defaultValue Default bool value.
     */
    SB_WASM BoolStoredParameter(
        const std::string& id,
        const std::string& name,
        const std::string& description,
        const bool defaultValue
    );

    // MARK: Overridden methods

    SB_WASM bool getValue() const override;
    SB_WASM void setValue(const bool newValue) override;

private:
    std::atomic<bool> atomicValue;
};

}
