//
//  BufferSizeRegulator.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include "RingBuffer.hpp"

#include <memory>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

using BufferSizeRegulatorCallbackFunction = void (*)(float* buffer, void* userPointer);

/**
 * @brief Converts a variable sized buffer stream into a fixed sized buffer stream.
 */
class BufferSizeRegulator {
public:
    BufferSizeRegulator(
        const uint targetNumberOfFrames,
        const BufferSizeRegulatorCallbackFunction callback,
        void* userPointer
    );
    ~BufferSizeRegulator();

    bool process(float* buffer, const uint numberOfSamples);

private:
    uint targetNumberOfFrames;
    BufferSizeRegulatorCallbackFunction callback;
    void* userPointer;

    std::unique_ptr<RingBuffer<float>> inputBuffer;
    std::unique_ptr<RingBuffer<float>> outputBuffer;
    float* tempBuffer;
};

}
