//
//  BusSelectNode.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2023. 06. 15..
//

#pragma once

#include <switchboard_core/AudioProcessorNode.hpp>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 *  BusSelectNode class.
 *  @brief Selects and forwards a single audio bus from multiple input audio buses to it's output
 */
class BusSelectNode : public AudioProcessorNode {
public:
    SB_WASM_EXPORT(BusSelectNode)

    /**
     *  @brief Initializes a BusSelectNode instance.
     */
    SB_WASM BusSelectNode();

    /**
     * @brief Gets the current selected bus index.
     *
     * @returns The bus index.
     */
    SB_WASM uint getSelectedBus() const;

    /**
     * @brief Sets the selected bus index.
     * @details Will return false if the bus index is bigger than or equal than max number of input buses.
     *
     * @param newValue The bus index to set.
     * @returns True if setting the selected bus index was successful.
     */
    SB_WASM bool setSelectedBus(const uint newValue);

    /**
     * @brief Gets the number of input buses of the node.
     *
     * @returns The number of input buses..
     */
    SB_WASM uint getNumberOfInputBuses() const;

    // MARK: Overridden methods

    SB_WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    SB_WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    SB_WASM bool process(AudioBusList& inBuses, AudioBusList& outBuses) override;

private:
    uint numberOfInputBuses;
    std::atomic<uint> selectedBus;
};

}
