//
//  BusSwitchNode.hpp
//  SwitchboardSDK
//
//  Created by Iván Nádor on 2024. 08. 08..
//

#pragma once

#include <switchboard_core/AudioProcessorNode.hpp>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 *  BusSwitchNode class.
 *  @brief Forwards a single input audio bus to a single output audio bus out of multiple output audio buses
 */
class BusSwitchNode : public AudioProcessorNode {
public:
    SB_WASM_EXPORT(BusSwitchNode)

    /**
     *  @brief Initializes a BusSwitchNode instance.
     */
    SB_WASM BusSwitchNode();

    /**
     * @brief Gets the current selected bus index.
     *
     * @returns The bus index.
     */
    SB_WASM uint getSelectedBus() const;

    /**
     * @brief Sets the selected bus index.
     * @details Will return false if the bus index is bigger than or equal than max number of output buses.
     *
     * @param newValue The bus index to set.
     * @returns True if setting the selected bus index was successful.
     */
    SB_WASM bool setSelectedBus(const uint newValue);

    /**
     * @brief Gets the number of output buses of the node.
     *
     * @returns The number of output buses.
     */
    SB_WASM uint getNumberOfOutputBuses() const;

    // MARK: Overridden methods

    SB_WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    SB_WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    SB_WASM bool process(AudioBusList& inBuses, AudioBusList& outBuses) override;

private:
    uint numberOfOutputBuses;
    std::atomic<uint> selectedBus;
};

}
