//
//  CircularBuffer.hpp
//  SwitchboardAudioEffects
//
//  Created by Balázs Kiss on 2022. 10. 30..
//

#pragma once

#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

struct CircularBuffer {
public:
    const int size;
    float* buffer;
    int readPointer;
    int writePointer;

    CircularBuffer(int size);

    void setReadPointer(const int value);

    void setWritePointer(const int value);

    void stepReadPointer(const int numberOfSteps = 1);

    void stepWritePointer(const int numberOfSteps = 1);

    float readSample();

    float readSample(const int index);

    void writeSample(const float value);

    float interpolate(float index);

    int getFillLevel();

    void reset();
};

};
