//
//  Counter.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 03. 30..
//

#pragma once

#include <atomic>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 * Counter class.
 * @brief A simple counter that can be used from multiple threads.
 */
class Counter {
public:
    /**
     * @brief Counter constructor.
     */
    Counter();

    /**
     * @brief Gets the next value. The first call to this method returns 1.
     *
     * @returns The next value.
     */
    uint getNext();

private:
    std::atomic<uint> value;
};

}
