//
//  FloatParameter.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 05. 26..
//

#pragma once

#include <switchboard_core/Parameter.hpp>

namespace switchboard {

/**
 * @brief Float parameter abstract class. Intended to be subclassed.
 */
class FloatParameter : public Parameter {
public:
    /**
     * @brief FloatParameter constructor.
     *
     * @param id The unique identifier of the parameter.
     * @param name The name of the parameter.
     * @param description The description of the parameter.
     */
    FloatParameter(const std::string& id, const std::string& name, const std::string& description);

    /**
     * @brief FloatParameter destructor.
     */
    virtual ~FloatParameter() = default;

    /**
     * @brief Gets the current value of the parameter.
     *
     * @returns The current value.
     */
    virtual float getValue() const = 0;

    /**
     * @brief Sets a new value for the parameter.
     *
     * @param newValue The new value for the parameter.
     */
    virtual void setValue(const float newValue) = 0;

    /**
     * @brief Gets the minimum value for the parameter.
     *
     * @returns The minimum value.
     */
    virtual float getMinimumValue() const = 0;

    /**
     * @brief Gets the maximum value for the parameter.
     *
     * @returns The maximum value.
     */
    virtual float getMaximumValue() const = 0;

    // MARK: Overidden methods

    void setValue(std::any newValue) override;
    std::any getAnyValue() override;
};

}
