//
//  FloatToInt.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 04. 04..
//

#pragma once

#include "Limit.hpp"

#include <climits>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 * @brief Converts a float (32 bit) audio value to int (32 bit).
 * @details The conversion happens in the sense of audio values, meaning float has a range of -1.0...1.0 and int has -2147483647...2147483647.
 *
 * @param value The input value in float.
 *
 * @returns The value in int.
 */
inline int floatToInt(float value) {
    return static_cast<int>(limit<float>(-1.0, 1.0, value) * INT_MAX);
}

/**
 *  @brief Convert a float buffer to a signed 32-bit integer buffer.
 *
 *  @param inputBuffer Input float buffer.
 *  @param outputBuffer Output signed 32-bit integer buffer.
 *  @param numberOfSamples Number of samples in the buffers.
 */
void floatToInt(const float* inputBuffer, int* outputBuffer, size_t numberOfSamples);

}
