//
//  GainNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include "Ramp.hpp"

#include <switchboard_core/SingleBusAudioProcessorNode.hpp>

namespace switchboard {

/**
 * GainNode class.
 * @brief Changes the gain of the audio that flows through this node.
 */
class GainNode : public SingleBusAudioProcessorNode {
public:
    SB_WASM_EXPORT(GainNode)

    SB_WASM GainNode();

    /**
     * @brief Creates a GainNode instance.
     *
     * @param config Configuration map for the node.
     */
    GainNode(const std::map<std::string, std::any>& config);

    /**
     * @brief Gets the current gain value.
     *
     * @returns The gain value.
     */
    SB_WASM float getGain() const;

    /**
     * @brief Sets the gain.
     *
     * @param newValue The gain value to set.
     */
    SB_WASM void setGain(const float newValue);

    // MARK: Overridden methods

    SB_WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat) override;
    SB_WASM bool process(AudioBus& inBus, AudioBus& outBus) override;

private:
    std::atomic<float> gain;
    Ramp gainRamp;

    void createParameters();
};

}
