//
//  Interleave.hpp
//  SwitchboardSDK
//
//  Created by Balazs Kiss on 2023. 04. 04..
//

#pragma once

#include <switchboard_core/AudioBuffer.hpp>
#include <switchboard_core/Switchboard.hpp>

namespace switchboard {

/**
 *  @brief Interleaves audio data from input buffers into output buffer.
 *  @details Size of output buffer has to be at least numberOfChannels * numberOfFrames.
 *
 *  @param inputBuffers Array of non-interleaved audio data arrays.
 *  @param outputBuffer Output audio data array where the interleaved data will be stored.
 *  @param numberOfChannels The number of channels to interleave.
 *  @param numberOfFrames The number of frames in the input buffers.
 */
template <typename T>
void interleave(const T** inputBuffers, T* outputBuffer, const uint numberOfChannels, const uint numberOfFrames);

/**
 *  @brief Interleaves input buffer channels into output buffer.
 *  @details Input and output buffers must have the same number of channels. Input and output buffers must have the same number of frames.
 *
 *  @param inputBuffer AudioBuffer to be interleaved. Must be non-interleaved.
 *  @param outputBuffer AudioBuffer to store input data. Must be interleaved.
 */
template <typename T>
void interleave(const AudioBuffer<T>& inputBuffer, AudioBuffer<T>& outputBuffer);

}
