//
//  MixerNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 03. 04..
//  Copyright © 2022. Synervoz Inc. All rights reserved.
//

#pragma once

#include <switchboard_core/AudioProcessorNode.hpp>

namespace switchboard {

/**
 * MixerNode class.
 * @brief Mixes multiple audio buses into a single audio bus.
 */
class MixerNode : public AudioProcessorNode {
public:
    SB_WASM_EXPORT(MixerNode)

    /**
     * @brief Creates a MixerNode instance.
     */
    SB_WASM MixerNode();

    // MARK: Overridden methods

    SB_WASM bool setNumberOfBuses(const uint numberOfInputBuses, const uint numberOfOutputBuses) override;
    SB_WASM bool setBusFormats(AudioBusFormatList& inputBusFormats, AudioBusFormatList& outputBusFormats) override;
    SB_WASM bool process(AudioBusList& inAudioBuses, AudioBusList& outAudioBuses) override;
};

}
