//
//  MonoToMultiChannelNode.hpp
//  SwitchboardSDK
//
//  Created by Balázs Kiss on 2022. 11. 02..
//

#pragma once

#include <switchboard_core/SingleBusAudioProcessorNode.hpp>

namespace switchboard {

/**
 * @brief Converts a mono audio bus to a multi-channel audio bus.
 */
class MonoToMultiChannelNode : public SingleBusAudioProcessorNode {
public:
    SB_WASM_EXPORT(MonoToMultiChannelNode)

    /**
     * @brief Initializes a MonoToMultiChannelNode instance.
     */
    SB_WASM MonoToMultiChannelNode();

    // MARK: Overridden methods

    SB_WASM bool setBusFormat(AudioBusFormat& inputBusFormat, AudioBusFormat& outputBusFormat);
    SB_WASM bool process(AudioBus& inBus, AudioBus& outBus);
};

}
